--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Casablanca
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "cas_marketkeep" }
DefineCharacter { name = "cas_shopkeep" }
DefineCharacter { name = "cas_otherkeep" }
-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "casablanca",
	available = false,

	layout =
	{
		-- Clouds
		SpriteLayer { image="clouds_03", time=270000, loop=true, htile=true, path={{0,50},{100,50},{700,50},{800,50}}, },
		SpriteLayer { image="clouds_03", time=240000, loop=true, path={{-400,40},{100,40},{700,40},{1200,40}}, },
		
		-- Planes
		SpriteLayer { imagelist=portPlanes, scale=.2, time=14000,hold=8000,bounce=true,
			path={{-80,70},{100,70},{750,70},{880,70}} },
		
		-- Boats
		SpriteLayer { imagelist=portBoats, scale=.12, time=215000,hold=8000,bounce=true,
			path={{-80,108},{100,108},{750,108},{880,108},},},
		SpriteLayer { imagelist=portBoats, scale=.25, time=115000,hold=5000,bounce=true,
			path={{880,112},{750,112},{100,112},{-80,112},},},
		
		
		-- TODO: Might want to add a boat mask or cut boat reflections -- going over building tops
		
		SpriteLayer { image="cas_boatmask", x=662+138/2,y=102+50/2 },
		EmptyBuilding { name="cas_lighthouse", character = {"traveler07"}, x=444+35/2,y=60+71/2 },
		SpriteLayer { image="cas_lightmask", x=425+74/2,y=125+40/2 },
		
		-- Dusty Haze back
		SpriteLayer { image="clouds_05", time=370000, loop=true, htile=true, path={{0,150},{100,150},{700,150},{800,150}}, },
		
		-- Left Cars
		SpriteLayer { image="car_07", farscale=.1,nearscale=.5,far=160,near=320,
			path={{155,608},{218,405},{277,211},{318,170},{344,153},{356,153},{365,175},},},
		SpriteLayer { image="car_12", farscale=.1,nearscale=.5,far=160,near=320,
			path={{341,142},{300,154},{274,321},{242,649},{238,674},},},
		
		
		SpriteLayer { image="cas_carmask2", x=306+90/2,y=135+140/2 },

		-- Right Car
		SpriteLayer { image="car_07", farscale=.1, nearscale=.5,far=160,near=320,
			path={{692,656},{560,460},{448,332},{395,288},}, },
		
		-- camel far
		SpriteLayer { image="camelwalk.xml", time=22000, scale=.32, hold=12000,bounce=true,
			path={{151,273},{251,271},{458,276},{537,274},}, },
		
		EmptyBuilding { name="cas_office", startweek=118, ambient="sfx/other_loop.ogg", x=567+113/2,y=61+161/2},
		
		Shop { name="cas_shop", character="cas_shopkeep", x=451+125/2,y=169+158/2},

		-- Horizontal Cars
		SpriteLayer { imagelist=portCars, scale=.5, hold=5000,bounce=true,
			path={{163,286},{434,288},{310,338},{846,329},},},
			
		

		Market { name="cas_market", character="cas_marketkeep", x=556+244/2,y=134+266/2,
			inventory = { mint=true, cashew=true, sugar=true, almond=true, milk=true, raspberry=true,} },

		EmptyBuilding { name="cas_other", character={"cas_otherkeep"}, x=154+62/2,y=28+313/2 },
		SpriteLayer { image="cas_towermask", ambient="sfx/other_loop.ogg", x=109+69/2,y=251+114/2 },
		
		SpriteLayer { image="cas_carmask", x=271+217/2,y=244+160/2},
		
		-- Dusty Hazefront
		SpriteLayer { image="clouds_05", time=270000, loop=true, htile=true, path={{0,250},{100,250},{700,250},{800,250}}, },
	}
}
